<div id="sidebar">
	<ul>
		<?php
			if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar() ) : ?>
			<li><h2>最新日志</h2>
				<?php query_posts('showposts=10'); ?>
				<ul>
					<?php while (have_posts()) : the_post(); ?>
					<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
					<?php endwhile;?>
				</ul>
			</li>
			<li><h2>最新评论</h2>
				<?php
				global $wpdb;
				$sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID,
				comment_post_ID, comment_author, comment_date_gmt, comment_approved,
				comment_type,comment_author_url,
				SUBSTRING(comment_content,1,35) AS com_excerpt
				FROM $wpdb->comments
				LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID =
				$wpdb->posts.ID)
				WHERE comment_approved = '1' AND comment_type = '' AND
				post_password = ''
				ORDER BY comment_date_gmt DESC
				LIMIT 10";
				$comments = $wpdb->get_results($sql);
				$output = $pre_HTML;
				$output .= "\n<ul>";
				foreach ($comments as $comment) {
				$output .= "\n<li>".strip_tags($comment->comment_author)
				.":" . "<a href=\"" . get_permalink($comment->ID) .
				"#comment-" . $comment->comment_ID . "\" title=\"on " .
				$comment->post_title . "\">" . strip_tags($comment->com_excerpt)
				."</a></li>";
				}
				$output .= "\n</ul>";
				$output .= $post_HTML;
				echo $output;?>	
			</li>
			<li><h2>热门日志</h2>
				<ul>
					<?php if (function_exists('get_most_viewed')): ?>    
					<?php get_most_viewed(); ?>    
					<?php endif; ?>
				</ul>
			</li>
			<li><h2>日志存档</h2>
				<form class="tags" id="archiveform" action=""> 
					<select name="archive_chrono" onchange="window.location = 
					(document.forms.archiveform.archive_chrono[ 
					document.forms.archiveform.archive_chrono.selectedIndex].value);"> 
					<option value=''>请选择月份查看</option> 
					<?php wp_get_archives('type=monthly&format=option&show_post_count=true'); ?> 
					</select> 
				</form>
			</li>
			<li><h2>标签云</h2>
				<div class="tags">
					<?php wp_tag_cloud('unit=px&smallest=12&largest=20'); ?>
				</div>
			</li>
			<?php wp_list_bookmarks(); ?>
			<li><h2>博客管理</h2>
				<ul>
					<?php wp_register(); ?>
					<li><?php wp_loginout(); ?></li>
					<?php wp_meta(); ?>
				</ul>
			</li>
		<?php endif; ?>
	</ul>
</div>
