/*
 * Easing Compatibility v1 - http://gsgd.co.uk/sandbox/jquery/easing
 *
 * Adds compatibility for applications that use the pre 1.2 easing names
 *
 * Copyright (c) 2007 George Smith
 * Licensed under the MIT License:
 *   http://www.opensource.org/licenses/mit-license.php
 */

/* globals jQuery */
(function($){
	$.extend( $.easing, {
		easeIn: function (x, t, b, c, d) {
			return $.easing.easeInQuad(x, t, b, c, d);
		},
		easeOut: function (x, t, b, c, d) {
			return $.easing.easeOutQuad(x, t, b, c, d);
		},
		easeInOut: function (x, t, b, c, d) {
			return $.easing.easeInOutQuad(x, t, b, c, d);
		},
		expoin: function(x, t, b, c, d) {
			return $.easing.easeInExpo(x, t, b, c, d);
		},
		expoout: function(x, t, b, c, d) {
			return $.easing.easeOutExpo(x, t, b, c, d);
		},
		expoinout: function(x, t, b, c, d) {
			return $.easing.easeInOutExpo(x, t, b, c, d);
		},
		bouncein: function(x, t, b, c, d) {
			return $.easing.easeInBounce(x, t, b, c, d);
		},
		bounceout: function(x, t, b, c, d) {
			return $.easing.easeOutBounce(x, t, b, c, d);
		},
		bounceinout: function(x, t, b, c, d) {
			return $.easing.easeInOutBounce(x, t, b, c, d);
		},
		elasin: function(x, t, b, c, d) {
			return $.easing.easeInElastic(x, t, b, c, d);
		},
		elasout: function(x, t, b, c, d) {
			return $.easing.easeOutElastic(x, t, b, c, d);
		},
		elasinout: function(x, t, b, c, d) {
			return $.easing.easeInOutElastic(x, t, b, c, d);
		},
		backin: function(x, t, b, c, d) {
			return $.easing.easeInBack(x, t, b, c, d);
		},
		backout: function(x, t, b, c, d) {
			return $.easing.easeOutBack(x, t, b, c, d);
		},
		backinout: function(x, t, b, c, d) {
			return $.easing.easeInOutBack(x, t, b, c, d);
		}
	});
})(jQuery);
