<?php
/**
 * @link http://biji.io
 *
 * @package WordPress
 * @subpackage Adams
 */
if (!defined('THEME_NAME')) define('THEME_NAME', 'Adams');
if (!defined('THEME_DB_VERSION')) define('THEME_DB_VERSION', 'v1.4.26');
if (version_compare($GLOBALS['wp_version'], '4.4-alpha', '<')) {
    wp_die('Please upgrade to version 4.4 or higher');
}

require(get_template_directory() . '/inc/core.de.php');

/**
 * 挂载脚本
 */
function biji_enqueue_scripts()
{
    wp_deregister_script('jquery');
    wp_enqueue_script(
        'jquery-min',
        '//cdn.staticfile.org/jquery/3.1.1/jquery.min.js',
        array(),
        THEME_DB_VERSION
    );
    wp_enqueue_script(
        'script-js',
        get_template_directory_uri() . '/static/script.js',
        array(),
        THEME_DB_VERSION
    );
    wp_enqueue_script(
        'ajax-comment',
        get_template_directory_uri() . '/static/ajax-comment.js',
        array(),
        THEME_DB_VERSION,
        true
    );
    wp_localize_script(
        'ajax-comment',
        'themeAdminAjax',
        array(
            'url' => admin_url('admin-ajax.php')
        )
    );
    if(!get_theme_mod('biji_setting_prettify')) {
        wp_enqueue_script(
            'prettify',
            '//cdn.staticfile.org/prettify/r298/prettify.js',
            array(),
            THEME_DB_VERSION
        );
    }
    wp_enqueue_script(
        'instantclick',
        '//cdn.staticfile.org/instantclick/3.0.1/instantclick.min.js',
        array(),
        THEME_DB_VERSION
    );
}

add_action('wp_enqueue_scripts', 'biji_enqueue_scripts', 1);

// 优化代码
remove_action('wp_head', 'feed_links_extra', 3); // 额外的feed,例如category, tag页
remove_action('wp_head', 'wp_generator'); //隐藏wordpress版本
remove_filter('the_content', 'wptexturize'); //取消标点符号转义
remove_action('admin_print_scripts', 'print_emoji_detection_script'); // 禁用Emoji表情
remove_action('admin_print_styles', 'print_emoji_styles');
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');
remove_filter('the_content_feed', 'wp_staticize_emoji');
remove_filter('comment_text_rss', 'wp_staticize_emoji');
remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
if (function_exists('add_theme_support')) add_theme_support('post-thumbnails'); //添加特色缩略图支持

// 禁止wp-embed.min.js
function disable_embeds_init()
{
    global $wp;
    $wp->public_query_vars = array_diff($wp->public_query_vars, array(
        'embed',
    ));
    remove_action('rest_api_init', 'wp_oembed_register_route');
    add_filter('embed_oembed_discover', '__return_false');
    remove_filter('oembed_dataparse', 'wp_filter_oembed_result', 10);
    remove_action('wp_head', 'wp_oembed_add_discovery_links');
    remove_action('wp_head', 'wp_oembed_add_host_js');
    add_filter('tiny_mce_plugins', 'disable_embeds_tiny_mce_plugin');
    add_filter('rewrite_rules_array', 'disable_embeds_rewrites');
}

add_action('init', 'disable_embeds_init', 9999);
function disable_embeds_tiny_mce_plugin($plugins)
{
    return array_diff($plugins, array('wpembed'));
}

function disable_embeds_rewrites($rules)
{
    foreach ($rules as $rule => $rewrite) {
        if (false !== strpos($rewrite, 'embed=true')) {
            unset($rules[$rule]);
        }
    }
    return $rules;
}

function disable_embeds_remove_rewrite_rules()
{
    add_filter('rewrite_rules_array', 'disable_embeds_rewrites');
    flush_rewrite_rules();
}

register_activation_hook(__FILE__, 'disable_embeds_remove_rewrite_rules');
function disable_embeds_flush_rewrite_rules()
{
    remove_filter('rewrite_rules_array', 'disable_embeds_rewrites');
    flush_rewrite_rules();
}

register_deactivation_hook(__FILE__, 'disable_embeds_flush_rewrite_rules');

// 阻止站内文章互相Pingback 
function theme_noself_ping(&$links)
{
    $home = get_theme_mod('home');
    foreach ($links as $l => $link)
        if (0 === strpos($link, $home))
            unset($links[$l]);
}

add_action('pre_ping', 'theme_noself_ping');

// 网页标题
function biji_add_theme_support_title()
{
    add_theme_support('title-tag');
}

add_action('after_setup_theme', 'biji_add_theme_support_title');

// 编辑器增强
function enable_more_buttons($buttons)
{
    $buttons[] = 'hr';
    $buttons[] = 'del';
    $buttons[] = 'sub';
    $buttons[] = 'sup';
    $buttons[] = 'fontselect';
    $buttons[] = 'fontsizeselect';
    $buttons[] = 'cleanup';
    $buttons[] = 'styleselect';
    $buttons[] = 'wp_page';
    $buttons[] = 'anchor';
    $buttons[] = 'backcolor';
    return $buttons;
}

add_filter("mce_buttons_3", "enable_more_buttons");

if(!get_theme_mod('biji_setting_prettify')) {
// 代码高亮
    function dangopress_esc_html($content)
    {
        if (!is_feed() || !is_robots()) {
            $content = preg_replace('/<code(.*)>/i', "<code class=\"prettyprint\" \$1>", $content);
        }
        $regex = '/(<code.*?>)(.*?)(<\/code>)/sim';
        return preg_replace_callback($regex, 'dangopress_esc_callback', $content);
    }

    function dangopress_esc_callback($matches)
    {
        $tag_open = $matches[1];
        $content = $matches[2];
        $tag_close = $matches[3];
        //$content = htmlspecialchars($content, ENT_NOQUOTES, get_bloginfo('charset'));
        $content = esc_html($content);

        return $tag_open . $content . $tag_close;
    }

    add_filter('the_content', 'dangopress_esc_html', 2);
    add_filter('comment_text', 'dangopress_esc_html', 2);
}
// 评论@回复
function idevs_comment_add_at($comment_text, $comment = '')
{
    if ($comment->comment_parent > 0) {
        $comment_text = '@<a href="#comment-' . $comment->comment_parent . '">' . get_comment_author($comment->comment_parent) . '</a> ' . $comment_text;
    }
    return $comment_text;
}

add_filter('comment_text', 'idevs_comment_add_at', 20, 2);

// 评论邮件
add_action('comment_post', 'comment_mail_notify');
/* comment_mail_notify v1.0 by willin kan. (所有回复都发邮件) */
function comment_mail_notify($comment_id)
{
    $comment = get_comment($comment_id);
    $parent_id = $comment->comment_parent ? $comment->comment_parent : '';
    $spam_confirmed = $comment->comment_approved;
    if (($parent_id != '') && ($spam_confirmed != 'spam')) {
        $wp_email = 'no-reply@' . preg_replace('#^www.#', '', strtolower($_SERVER['SERVER_NAME'])); //e-mail 发出点, no-reply 可改为可用的 e-mail.
        $to = trim(get_comment($parent_id)->comment_author_email);
        $subject = '您在 [' . get_option("blogname") . '] 的留言有了回复';
        $message = '
    <table cellpadding="0" cellspacing="0" class="email-container" align="center" width="550" style="font-size: 15px; font-weight: normal; line-height: 22px; text-align: left; border: 1px solid rgb(177, 213, 245); width: 550px;">
<tbody><tr>
<td>
<table cellpadding="0" cellspacing="0" class="padding" width="100%" style="padding-left: 40px; padding-right: 40px; padding-top: 30px; padding-bottom: 35px;">
<tbody>
<tr class="logo">
<td align="center">
<table class="logo" style="margin-bottom: 10px;">
<tbody>
<tr>
<td>
<span style="font-size: 22px;padding: 10px 20px;margin-bottom: 5%;color: #65c5ff;border: 1px solid;box-shadow: 0 5px 20px -10px;border-radius: 2px;display: inline-block;">' . get_option("blogname") . '</span>
</td>
</tr>
</tbody>
</table>
</td>
</tr>
<tr class="content">
<td>
<hr style="height: 1px;border: 0;width: 100%;background: #eee;margin: 15px 0;display: inline-block;">
<p>Hi ' . trim(get_comment($parent_id)->comment_author) . '!<br>Your comment by "' . get_the_title($comment->comment_post_ID) . '":</p>
<p style="background: #eee;padding: 1em;text-indent: 2em;line-height: 30px;">' . trim(get_comment($parent_id)->comment_content) . '</p>
<p>' . $comment->comment_author . ' give you reply:</p>
<p style="background: #eee;padding: 1em;text-indent: 2em;line-height: 30px;">' . trim($comment->comment_content) . '</p>
</td>
</tr>
<tr>
<td align="center">
<table cellpadding="12" border="0" style="font-family: Lato, \'Lucida Sans\', \'Lucida Grande\', SegoeUI, \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px; font-weight: bold; line-height: 25px; color: #444444; text-align: left;">
<tbody><tr>
<td style="text-align: center;">
<a target="_blank" style="color: #fff;background: #65c5ff;box-shadow: 0 5px 20px -10px #44b0f1;border: 1px solid #44b0f1;width: 200px;font-size: 14px;padding: 10px 0;border-radius: 2px;margin: 10% 0 5%;text-align:center;display: inline-block;text-decoration: none;" href="' . htmlspecialchars(get_comment_link($parent_id)) . '">Now Reply</a>
</td>
</tr>
</tbody></table>
</td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>

<table border="0" cellpadding="0" cellspacing="0" align="center" class="footer" style="max-width: 550px; font-family: Lato, \'Lucida Sans\', \'Lucida Grande\', SegoeUI, \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 15px; line-height: 22px; color: #444444; text-align: left; padding: 20px 0; font-weight: normal;">
<tbody><tr>
<td align="center" style="text-align: center; font-size: 12px; line-height: 18px; color: rgb(163, 163, 163); padding: 5px 0px;">
</td>
</tr>
<tr>
<td style="text-align: center; font-weight: normal; font-size: 12px; line-height: 18px; color: rgb(163, 163, 163); padding: 5px 0px;">
<p>Please do not reply to this message , because it is automatically sent.</p>
<p>© ' . date("Y") . ' <a name="footer_copyright" href="' . home_url() . '" style="color: rgb(43, 136, 217); text-decoration: underline;" target="_blank">' . get_option("blogname") . '</a></p>
</td>
</tr>
</tbody>
</table>';
        $from = "From: \"" . get_option('blogname') . "\" <$wp_email>";
        $headers = "$from\nContent-Type: text/html; charset=" . get_option('blog_charset') . "\n";
        wp_mail($to, $subject, $message, $headers);
    }
}

// -- END ----------------------------------------
function recover_comment_fields($comment_fields)
{
    $comment = array_shift($comment_fields);
    $comment_fields = array_merge($comment_fields, array('comment' => $comment));
    return $comment_fields;
}

add_filter('comment_form_fields', 'recover_comment_fields');

// 404页面
function biji_404_template($template)
{
    if (!is_404()) return $template;
    ?>
    <!DOCTYPE HTML>
    <html>
    <head>
        <meta charset="UTF-8"/>
        <meta name="robots" content="none"/>
        <title>404 Not Found</title>
        <style>
            * {
                font-family: "Microsoft Yahei";
                margin: 0;
                font-weight: lighter;
                text-decoration: none;
                text-align: center;
                line-height: 2.2em;
            }

            html, body {
                height: 100%;
            }

            h1 {
                font-size: 100px;
                line-height: 1em;
            }

            table {
                width: 100%;
                height: 100%;
                border: 0;
            }
        </style>
        <?php if (get_theme_mod('biji_setting_style')) echo "<div style=\"display:none\">" . get_theme_mod('biji_setting_style') . "</div>\n"; ?>
    </head>
    <body>
    <table cellspacing="0" cellpadding="0">
        <tr>
            <td>
                <table cellspacing="0" cellpadding="0">
                    <tr>
                        <td>
                            <h1>404</h1>
                            <h3>大事不妙啦！</h3>
                            <p>你访问的页面好像不小心被博主给弄丢了~<br/><a href="<?php bloginfo('siteurl'); ?>">惩罚博主 ></a></p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    </body>
    </html>
    <?php die;
}

add_filter('template_include', 'biji_404_template');

/**
 * AJAX 提交评论
 * by：https://fatesinger.com/jquery-ajax-comments.html
 **/
if (!function_exists('biji_ajax_comment_scripts')) :
    function biji_ajax_comment_scripts()
    {
        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
        wp_localize_script('ajax-comment', 'ajaxcomment', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'order' => get_option('comment_order'),
            'formpostion' => 'after',
        ));
    }
endif;

if (!function_exists('biji_ajax_comment_err')) :
    function biji_ajax_comment_err($a)
    {
        header('HTTP/1.0 500 Internal Server Error');
        header('Content-Type: text/plain;charset=UTF-8');
        echo $a;
        exit;
    }
endif;

if (!function_exists('biji_ajax_comment_callback')) :
    function biji_ajax_comment_callback()
    {
        $comment = wp_handle_comment_submission(wp_unslash($_POST));
        if (is_wp_error($comment)) {
            $data = $comment->get_error_data();
            if (!empty($data)) {
                biji_ajax_comment_err($comment->get_error_message());
            } else {
                exit;
            }
        }
        $user = wp_get_current_user();
        do_action('set_comment_cookies', $comment, $user);
        $GLOBALS['comment'] = $comment;
        ?>
        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
            <div id="comment-<?php comment_ID(); ?>" class="comment-body new-comment">
                <div class="comment-author vcard">
                    <?php echo get_avatar($comment, $size = '64'); ?>
                    <?php printf(__('<cite class="fn">%s</cite> <span class="says">说道：</span>'), get_comment_author_link()); ?>
                </div>
                <div class="comment-meta commentmetadata" style="right:8px;"><a
                            href="<?php echo esc_url(get_comment_link($comment->comment_ID)); ?>"><?php printf(__('%1$s at %2$s'), get_comment_date(), get_comment_time()); ?></a><?php edit_comment_link(__('(Edit)'), ' '); ?>
                </div>
                <p><?php comment_text(); ?></p>
                <div class="reply">提交成功</div>
            </div>
        </li>
        <?php die();
    }
endif;

add_action('wp_enqueue_scripts', 'biji_ajax_comment_scripts');
add_action('wp_ajax_nopriv_ajax_comment', 'biji_ajax_comment_callback');
add_action('wp_ajax_ajax_comment', 'biji_ajax_comment_callback');
/**
 * Theme Update Checker Library 1.2 ／ 主题更新推送
 * http://w-shadow.com/
 * Copyright 2012 Janis Elsts
 * Licensed under the GNU GPL license.
 * http://www.gnu.org/licenses/gpl.html
 */
if (!class_exists('ThemeUpdateChecker')):
    class ThemeUpdateChecker
    {
        public $theme = '';
        public $metadataUrl = '';
        public $enableAutomaticChecking = true;
        protected $optionName = '';
        protected $automaticCheckDone = false;
        protected static $filterPrefix = 'tuc_request_update_';

        public function __construct($theme, $metadataUrl, $enableAutomaticChecking = true)
        {
            $this->metadataUrl = $metadataUrl;
            $this->enableAutomaticChecking = $enableAutomaticChecking;
            $this->theme = $theme;
            $this->optionName = 'external_theme_updates-' . $this->theme;
            $this->installHooks();
        }

        public function installHooks()
        {
            if ($this->enableAutomaticChecking) {
                add_filter('pre_set_site_transient_update_themes', array($this, 'onTransientUpdate'));
            }
            add_filter('site_transient_update_themes', array($this, 'injectUpdate'));
            add_action('delete_site_transient_update_themes', array($this, 'deleteStoredData'));
        }

        public function requestUpdate($queryArgs = array())
        {
            $queryArgs['installed_version'] = $this->getInstalledVersion();
            $queryArgs = apply_filters(self::$filterPrefix . 'query_args-' . $this->theme, $queryArgs);
            $options = array(
                'timeout' => 10,
            );
            $options = apply_filters(self::$filterPrefix . 'options-' . $this->theme, $options);
            $url = $this->metadataUrl;
            if (!empty($queryArgs)) {
                $url = add_query_arg($queryArgs, $url);
            }
            $result = wp_remote_get($url, $options);
            $themeUpdate = null;
            $code = wp_remote_retrieve_response_code($result);
            $body = wp_remote_retrieve_body($result);
            if (($code == 200) && !empty($body)) {
                $themeUpdate = ThemeUpdate::fromJson($body);
                if (($themeUpdate != null) && version_compare($themeUpdate->version, $this->getInstalledVersion(), '<=')) {
                    $themeUpdate = null;
                }
            }
            $themeUpdate = apply_filters(self::$filterPrefix . 'result-' . $this->theme, $themeUpdate, $result);
            return $themeUpdate;
        }

        public function getInstalledVersion()
        {
            if (function_exists('wp_get_theme')) {
                $theme = wp_get_theme($this->theme);
                return $theme->get('Version');
            }
            foreach (get_themes() as $theme) {
                if ($theme['Stylesheet'] === $this->theme) {
                    return $theme['Version'];
                }
            }
            return '';
        }

        public function checkForUpdates()
        {
            $state = get_option($this->optionName);
            if (empty($state)) {
                $state = new StdClass;
                $state->lastCheck = 0;
                $state->checkedVersion = '';
                $state->update = null;
            }
            $state->lastCheck = time();
            $state->checkedVersion = $this->getInstalledVersion();
            update_option($this->optionName, $state);
            $state->update = $this->requestUpdate();
            update_option($this->optionName, $state);
        }

        public function onTransientUpdate($value)
        {
            if (!$this->automaticCheckDone) {
                $this->checkForUpdates();
                $this->automaticCheckDone = true;
            }
            return $value;
        }

        public function injectUpdate($updates)
        {
            $state = get_option($this->optionName);
            if (!empty($state) && isset($state->update) && !empty($state->update)) {
                $updates->response[$this->theme] = $state->update->toWpFormat();
            }
            return $updates;
        }

        public function deleteStoredData()
        {
            delete_option($this->optionName);
        }

        public function addQueryArgFilter($callback)
        {
            add_filter(self::$filterPrefix . 'query_args-' . $this->theme, $callback);
        }

        public function addHttpRequestArgFilter($callback)
        {
            add_filter(self::$filterPrefix . 'options-' . $this->theme, $callback);
        }

        public function addResultFilter($callback)
        {
            add_filter(self::$filterPrefix . 'result-' . $this->theme, $callback, 10, 2);
        }
    }
endif;
if (!class_exists('ThemeUpdate')):
    class ThemeUpdate
    {
        public $version;
        public $details_url;
        public $download_url;

        public static function fromJson($json)
        {
            $apiResponse = json_decode($json);
            if (empty($apiResponse) || !is_object($apiResponse)) {
                return null;
            }
            $valid = isset($apiResponse->version) && !empty($apiResponse->version) && isset($apiResponse->details_url) && !empty($apiResponse->details_url);
            if (!$valid) {
                return null;
            }
            $update = new self();
            foreach (get_object_vars($apiResponse) as $key => $value) {
                $update->$key = $value;
            }
            return $update;
        }

        public function toWpFormat()
        {
            $update = array(
                'new_version' => $this->version,
                'url' => $this->details_url,
            );
            if (!empty($this->download_url)) {
                $update['package'] = $this->download_url;
            }
            return $update;
        }
    }
endif;
$mytheme_update_checker = new ThemeUpdateChecker(
    'adams',
    'https://biji.io/update/adams.json'
);

// 全部配置完毕
